# 剑指 Offer 题目分类

下表划分了各题使用的算法与数据结构。由于题目可能存在多种解法，本表格只列举最优解法（时间与空间复杂度最低）的对应算法。

| 题目                               | 算法分类                 | 数据结构分类    |
| ---------------------------------- | ------------------------ | --------------- |
| 03. 数组中重复的数字               | 查找算法                 | 数组            |
| 04. 二维数组中的查找               | 查找算法                 | 数组            |
| 05. 替换空格                       |                          | 字符串          |
| 06. 从尾到头打印链表               |                          | 栈 / 队列，链表 |
| 07. 重建二叉树                     | 分治算法                 | 树，哈希表      |
| 09. 用两个栈实现队列               |                          | 栈 / 队列       |
| 10-I. 斐波那契数列                 | 动态规划                 |                 |
| 10-II. 青蛙跳台阶问题              | 动态规划                 |                 |
| 11. 旋转数组的最小数字             | 查找算法                 | 数组            |
| 12. 矩阵中的路径                   | 回溯算法，搜索算法       | 数组，图        |
| 13. 机器人的运动范围               | 回溯算法，搜索算法       | 数组，图        |
| 14-I. 剪绳子                       | 贪心算法，数学           |                 |
| 14- II. 剪绳子 II                  | 贪心算法，分治算法，数学 |                 |
| 15. 二进制中 1 的个数              | 位运算                   |                 |
| 16. 数值的整数次方                 | 分治算法，位运算         |                 |
| 17. 打印从 1 到最大的 n 位数       |                          | 数组            |
| 18. 删除链表的节点                 | 双指针                   | 链表            |
| 19. 正则表达式匹配                 | 动态规划                 | 字符串          |
| 20. 表示数值的字符串               |                          | 字符串          |
| 21. 调整数组顺序使奇数位于偶数前面 | 双指针                   | 数组            |
| 22. 链表中倒数第 k 个节点          | 双指针                   | 链表            |
| 24. 反转链表                       | 双指针                   | 链表            |
| 25. 合并两个排序的链表             | 双指针                   | 链表            |
| 26. 树的子结构                     | 搜索算法                 | 树              |
| 27. 二叉树的镜像                   | 搜索算法                 | 栈 / 队列，树   |
| 28. 对称的二叉树                   | 搜索算法                 | 树              |
| 29. 顺时针打印矩阵                 | 模拟                     | 数组            |
| 30. 包含 min 函数的栈              | 排序                     | 栈 / 队列       |
| 31. 栈的压入、弹出序列             | 模拟                     | 栈 / 队列       |
| 32-I. 从上到下打印二叉树           | 搜索算法                 | 栈 / 队列，树   |
| 32-II. 从上到下打印二叉树 II       | 搜索算法                 | 栈 / 队列，树   |
| 32-III. 从上到下打印二叉树 III     | 搜索算法                 | 栈 / 队列，树   |
| 33. 二叉搜索树的后序遍历序列       | 分治算法                 | 栈 / 队列，树   |
| 34. 二叉树中和为某一值的路径       | 回溯算法，搜索算法       | 树              |
| 35. 复杂链表的复制                 |                          | 链表            |
| 36. 二叉搜索树与双向链表           | 搜索算法，双指针         | 树              |
| 37. 序列化二叉树                   | 搜索算法                 | 树              |
| 38. 字符串的排列                   | 回溯算法                 | 字符串，哈希表  |
| 39. 数组中出现次数超过一半的数字   |                          | 数组            |
| 40. 最小的 k 个数                  | 排序                     | 数组，堆        |
| 41. 数据流中的中位数               | 排序                     | 堆              |
| 42. 连续子数组的最大和             | 动态规划                 | 数组            |
| 43. 1 ～ n整数中 1 出现的次数      | 数学                     |                 |
| 44. 数字序列中某一位的数字         | 数学                     |                 |
| 45. 把数组排成最小的数             | 排序                     | 字符串          |
| 46. 把数字翻译成字符串             | 动态规划                 | 字符串          |
| 47. 礼物的最大价值                 | 动态规划                 | 数组            |
| 48. 最长不含重复字符的子字符串     | 动态规划，双指针         | 哈希表          |
| 49. 丑数                           | 动态规划                 |                 |
| 50. 第一个只出现一次的字符         |                          | 哈希表          |
| 51. 数组中的逆序对                 | 分治算法                 | 数组            |
| 52. 两个链表的第一个公共节点       | 双指针                   | 链表            |
| 53-I. 在排序数组中查找数字 I       | 查找算法                 | 数组            |
| 53-II. 0 ～ n - 1 中缺失的数字     | 查找算法                 | 数组            |
| 54. 二叉搜索树的第 k 大节点        | 搜索算法                 | 树              |
| 55-I. 二叉树的深度                 | 搜索算法                 | 树              |
| 55-II. 平衡二叉树                  | 搜索算法                 | 树              |
| 56-I. 数组中数字出现的次数         | 位运算                   | 数组            |
| 56-II. 数组中数字出现的次数 II     | 位运算                   | 数组            |
| 57. 和为 s 的两个数字              | 双指针                   | 数组            |
| 57-II. 和为 s 的连续正数序列       | 双指针                   | 数组            |
| 58-I. 翻转单词顺序                 | 双指针                   | 字符串          |
| 58-II. 左旋转字符串                |                          | 字符串          |
| 59-I. 滑动窗口的最大值             | 排序                     | 数组，栈 / 队列 |
| 59-II. 队列的最大值                | 排序                     | 数组，栈 / 队列 |
| 60. n 个骰子的点数                 | 动态规划                 |                 |
| 61. 扑克牌中的顺子                 | 排序                     | 数组，哈希表    |
| 62. 圆圈中最后剩下的数字           | 数学                     |                 |
| 63. 股票的最大利润                 | 动态规划                 | 数组            |
| 64. 求 1 + 2 + … + n               |                          |                 |
| 65. 不用加减乘除做加法             | 位运算                   |                 |
| 66. 构建乘积数组                   | 数学                     | 数组            |
| 67. 把字符串转换成整数             |                          | 字符串          |
| 68-I. 二叉搜索树的最近公共祖先     | 搜索算法                 | 树              |
| 68-II. 二叉树的最近公共祖先        | 搜索算法                 | 树              |
